/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.phys;

import com.mojang.minecraft.b;
import com.mojang.minecraft.b.a;
import java.io.Serializable;

public class AABB
implements Serializable {
    public static final long serialVersionUID = 0L;
    private float epsilon = 0.0f;
    public float x0;
    public float y0;
    public float z0;
    public float x1;
    public float y1;
    public float z1;

    public AABB(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.x0 = f2;
        this.y0 = f3;
        this.z0 = f4;
        this.x1 = f5;
        this.y1 = f6;
        this.z1 = f7;
    }

    public AABB expand(float f2, float f3, float f4) {
        float f5 = this.x0;
        float f6 = this.y0;
        float f7 = this.z0;
        float f8 = this.x1;
        float f9 = this.y1;
        float f10 = this.z1;
        if (f2 < 0.0f) {
            f5 += f2;
        }
        if (f2 > 0.0f) {
            f8 += f2;
        }
        if (f3 < 0.0f) {
            f6 += f3;
        }
        if (f3 > 0.0f) {
            f9 += f3;
        }
        if (f4 < 0.0f) {
            f7 += f4;
        }
        if (f4 > 0.0f) {
            f10 += f4;
        }
        return new AABB(f5, f6, f7, f8, f9, f10);
    }

    public AABB grow(float f2, float f3, float f4) {
        float f5 = this.x0 - f2;
        float f6 = this.y0 - f3;
        float f7 = this.z0 - f4;
        f2 = this.x1 + f2;
        f3 = this.y1 + f3;
        float f8 = this.z1 + f4;
        return new AABB(f5, f6, f7, f2, f3, f8);
    }

    public AABB cloneMove(float f2, float f3, float f4) {
        return new AABB(this.x0 + f4, this.y0 + f3, this.z0 + f4, this.x1 + f2, this.y1 + f3, this.z1 + f4);
    }

    public float clipXCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return f2;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.x1 <= this.x0) {
            float f4;
            f3 = this.x0 - aABB.x1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.x0 >= this.x1) {
            float f5;
            f3 = this.x1 - aABB.x0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public float clipYCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return f2;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.y1 <= this.y0) {
            float f4;
            f3 = this.y0 - aABB.y1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.y0 >= this.y1) {
            float f5;
            f3 = this.y1 - aABB.y0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public float clipZCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return f2;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.z1 <= this.z0) {
            float f4;
            f3 = this.z0 - aABB.z1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.z0 >= this.z1) {
            float f5;
            f3 = this.z1 - aABB.z0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public boolean intersects(AABB aABB) {
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return false;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return false;
        }
        return !(aABB.z1 <= this.z0) && !(aABB.z0 >= this.z1);
    }

    public boolean intersectsInner(AABB aABB) {
        if (aABB.x1 < this.x0 || aABB.x0 > this.x1) {
            return false;
        }
        if (aABB.y1 < this.y0 || aABB.y0 > this.y1) {
            return false;
        }
        return !(aABB.z1 < this.z0) && !(aABB.z0 > this.z1);
    }

    public void move(float f2, float f3, float f4) {
        this.x0 += f2;
        this.y0 += f3;
        this.z0 += f4;
        this.x1 += f2;
        this.y1 += f3;
        this.z1 += f4;
    }

    public boolean intersects(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f5 <= this.x0 || f2 >= this.x1) {
            return false;
        }
        if (f6 <= this.y0 || f3 >= this.y1) {
            return false;
        }
        return !(f7 <= this.z0) && !(f4 >= this.z1);
    }

    public boolean contains(a a2) {
        if (a2.a <= this.x0 || a2.a >= this.x1) {
            return false;
        }
        if (a2.b <= this.y0 || a2.b >= this.y1) {
            return false;
        }
        return !(a2.c <= this.z0) && !(a2.c >= this.z1);
    }

    public float getSize() {
        float f2 = this.x1 - this.x0;
        float f3 = this.y1 - this.y0;
        float f4 = this.z1 - this.z0;
        return (f2 + f3 + f4) / 3.0f;
    }

    public AABB shrink(float f2, float f3, float f4) {
        float f5 = this.x0;
        float f6 = this.y0;
        float f7 = this.z0;
        float f8 = this.x1;
        float f9 = this.y1;
        float f10 = this.z1;
        if (f2 < 0.0f) {
            f5 -= f2;
        }
        if (f2 > 0.0f) {
            f8 -= f2;
        }
        if (f3 < 0.0f) {
            f6 -= f3;
        }
        if (f3 > 0.0f) {
            f9 -= f3;
        }
        if (f4 < 0.0f) {
            f7 -= f4;
        }
        if (f4 > 0.0f) {
            f10 -= f4;
        }
        return new AABB(f5, f6, f7, f8, f9, f10);
    }

    public AABB copy() {
        return new AABB(this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
    }

    public b clip(a a2, a a3) {
        a a4 = a2.a(a3, ((AABB)object).x0);
        a a5 = a2.a(a3, ((AABB)object).x1);
        a a6 = a2.b(a3, ((AABB)object).y0);
        a a7 = a2.b(a3, ((AABB)object).y1);
        a a8 = a2.c(a3, ((AABB)object).z0);
        a3 = a2.c(a3, ((AABB)object).z1);
        if (!((AABB)object).a(a4)) {
            a4 = null;
        }
        if (!((AABB)object).a(a5)) {
            a5 = null;
        }
        if (!((AABB)object).b(a6)) {
            a6 = null;
        }
        if (!((AABB)object).b(a7)) {
            a7 = null;
        }
        if (!((AABB)object).c(a8)) {
            a8 = null;
        }
        if (!((AABB)object).c(a3)) {
            a3 = null;
        }
        Object object = null;
        if (a4 != null) {
            object = a4;
        }
        if (a5 != null && (object == null || a2.b(a5) < a2.b((a)object))) {
            object = a5;
        }
        if (a6 != null && (object == null || a2.b(a6) < a2.b((a)object))) {
            object = a6;
        }
        if (a7 != null && (object == null || a2.b(a7) < a2.b((a)object))) {
            object = a7;
        }
        if (a8 != null && (object == null || a2.b(a8) < a2.b((a)object))) {
            object = a8;
        }
        if (a3 != null && (object == null || a2.b(a3) < a2.b((a)object))) {
            object = a3;
        }
        if (object == null) {
            return null;
        }
        int n2 = -1;
        if (object == a4) {
            n2 = 4;
        }
        if (object == a5) {
            n2 = 5;
        }
        if (object == a6) {
            n2 = 0;
        }
        if (object == a7) {
            n2 = 1;
        }
        if (object == a8) {
            n2 = 2;
        }
        if (object == a3) {
            n2 = 3;
        }
        return new b(0, 0, 0, n2, (a)object);
    }

    private boolean a(a a2) {
        if (a2 == null) {
            return false;
        }
        return a2.b >= this.y0 && a2.b <= this.y1 && a2.c >= this.z0 && a2.c <= this.z1;
    }

    private boolean b(a a2) {
        if (a2 == null) {
            return false;
        }
        return a2.a >= this.x0 && a2.a <= this.x1 && a2.c >= this.z0 && a2.c <= this.z1;
    }

    private boolean c(a a2) {
        if (a2 == null) {
            return false;
        }
        return a2.a >= this.x0 && a2.a <= this.x1 && a2.b >= this.y0 && a2.b <= this.y1;
    }
}

